import os
import sys
from http.server import SimpleHTTPRequestHandler, HTTPServer
import tempfile
import subprocess

flexsim_path = os.path.realpath(os.getenv("FLEXSIM_PATH", r"C:\Program Files\FlexSim 2024 Update 2\program\flexsim.exe"))
script_path = os.path.realpath(__file__)
script_dir = os.path.dirname(script_path)
model_path = os.path.join(script_dir, "model.fsm")
pfms_path = os.path.join(script_dir, "pfms.txt")
program_dir = os.path.dirname(flexsim_path)
web_dir = os.path.join(script_dir, "web")

PORT = int(os.getenv("FLEXSIM_SERVER_PORT", "8000"))
EVAL_LICENSE = os.getenv("FLEXSIM_EVAL_LICENSE", "False") == "True"
ARGS = os.getenv("FLEXSIM_ARGS", "")

maintenance = "nogui" + ("_evaluationlicense" if EVAL_LICENSE else "")

sys.path.append(script_dir)

def eprint(*args, **kwargs):
    print(*args, file=sys.stderr, **kwargs)

class FlexSimModelRequestHandler(SimpleHTTPRequestHandler):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, directory=web_dir, **kwargs)

    def do_POST(self):
        result = b"{}"
        content_len = int(self.headers.get('Content-Length'))
        post_body = self.rfile.read(content_len)

        # the post body is json
        # write it to a file and call FlexSim
        with tempfile.NamedTemporaryFile(delete_on_close=False) as f:
            f.write(post_body)
            f.close()

            args = [flexsim_path, model_path, "/maintenance", maintenance, "/paramdata", f.name, ARGS]
            proc = subprocess.Popen(args)
            proc.wait()

        # The model saves its results to a file
        # Send that file as the result 
        with open(pfms_path, 'rb') as f:
            self.send_response(200)
            self.send_header("Content-type", "application/json")
            self.end_headers()
            self.wfile.write(f.read())

def main():
    print("setting port", PORT)
    server_address = ('', PORT)
    httpd = HTTPServer(server_address, FlexSimModelRequestHandler)
    print("serving...")
    httpd.serve_forever()

if __name__ == "__main__":
    main()